---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：51-VCL プロバイダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Provider.VCL.pas` - VCL プロバイダー実装（301行）
- E-02: `src/Horse.Provider.Abstract.pas` - 抽象プロバイダー（77行）
- E-03: `src/Horse.Constants.pas` - 定数定義（18行）
- E-04: `src/Horse.WebModule.pas` - WebModule実装（118行）
- E-05: `src/Horse.Provider.IOHandleSSL.pas` - SSL設定実装（162行）
- E-06: `src/Horse.pas` - メインユニット（117行）
- E-07: `samples/delphi/vcl/src/Main.Form.pas` - VCLサンプル（79行）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HORSE_VCL コンパイルディレクティブで有効化 | E-01: 5行目 `{$IF DEFINED(HORSE_VCL)}` | ○ |
| C-02 | TIdHTTPWebBrokerBridgeを使用 | E-01: 10行目, 27行目, 86行目 | ○ |
| C-03 | デフォルトポートは9000 | E-03: 11行目 `DEFAULT_PORT = 9000` | ○ |
| C-04 | デフォルトホストは'0.0.0.0' | E-03: 10行目 `DEFAULT_HOST = '0.0.0.0'` | ○ |
| C-05 | KeepConnectionAlive初期値はTrue | E-01: 298行目 `THorseProvider.SetKeepConnectionAlive(True)` | ○ |
| C-06 | SSL/TLS暗号化対応 | E-01: 155-167行目 InitServerIOHandlerSSLOpenSSL | ○ |
| C-07 | MaxConnections設定可能 | E-01: 182-186行目 | ○ |
| C-08 | ListenQueue設定可能 | E-01: 188-189行目, 194行目 | ○ |
| C-09 | OnAuthentication イベントでVHandled=True | E-01: 262-265行目 | ○ |
| C-10 | StopListen時に未起動なら例外 | E-01: 225行目 `raise Exception.Create('Horse not listen')` | ○ |
| C-11 | THorseProviderAbstractを継承 | E-01: 19行目 `THorseProvider = class(THorseProviderAbstract)` | ○ |
| C-12 | IsRunningでサーバー状態確認 | E-01: 77-80行目 | ○ |
| C-13 | DoOnListenでコールバック実行 | E-02: 39-43行目 | ○ |
| C-14 | DoOnStopListenでコールバック実行 | E-02: 45-49行目 | ○ |
| C-15 | VCLメインフォームとの関連 | E-08: 画面No.1とのマッピング | ○ |
| C-16 | THorseWebModuleでリクエスト処理 | E-01: 180行目, E-04: 87-110行目 | ○ |
| C-17 | UnInitializeでリソース解放 | E-01: 292-295行目 | ○ |
| C-18 | OnQuerySSLPortでSSL判定 | E-01: 108-111行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードの根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] VCL プロバイダーの条件コンパイル（HORSE_VCL）が正しく理解されているか
- [ ] SSL/TLS設定の記述が実装と一致しているか
- [ ] サンプルコードの使用方法が実際の動作と一致しているか
